/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property.workflow;

import filenet.vw.api.VWAttachment;
import filenet.vw.api.VWWorkflowDefinition;
import filenet.vw.api.VWWorkflowSignature;
import filenet.vw.base.VWDebug;
import filenet.vw.idm.toolkit.IVWIDMDialog;
import filenet.vw.idm.toolkit.IVWIDMItem;
import filenet.vw.idm.toolkit.VWIDMBaseFactory;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.design.property.event.IVWCoordinationEventListener;
import filenet.vw.toolkit.design.property.event.IVWMapChangedListener;
import filenet.vw.toolkit.design.property.event.VWCoordinationEvent;
import filenet.vw.toolkit.design.property.event.VWMapChangedEvent;
import filenet.vw.toolkit.design.property.resources.VWResource;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.uicontrols.border.IVWToolbarBorderActionListener;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderActionEvent;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderClientActionEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

class VWWSGeneralTabPanel
extends JPanel
implements IVWMapChangedListener,
ActionListener,
IVWToolbarBorderActionListener,
IVWCoordinationEventListener {
    private VWAuthPropertyData m_authPropertyData = null;
    private VWToolbarBorder m_incomingWSAttachmentFolderBorder = null;
    private JTextField m_incomingWSAttachmentFolder = null;
    private JButton m_browseButton = null;
    private JCheckBox m_validateUsingSchemaCheckBox = null;
    private JCheckBox m_versionAgnosticCheckBox = null;
    private JTextArea m_versionAgnosticTextArea = null;

    VWWSGeneralTabPanel() {
    }

    public void mapChanged(VWMapChangedEvent event) {
        switch (event.getID()) {
            case 555: {
                this.updateVersionAgnosticControls();
            }
        }
    }

    public void actionPerformed(ActionEvent event) {
        try {
            VWWorkflowDefinition wfDefinition;
            if (this.m_authPropertyData != null && (wfDefinition = this.m_authPropertyData.getWorkflowDefinition()) != null) {
                Object src = event.getSource();
                if (src.equals(this.m_browseButton)) {
                    IVWIDMItem idmItem = null;
                    IVWIDMItem idmDoc = null;
                    String[] resources = VWStringUtils.getResourcesFromString(VWResource.s_select_withHK);
                    IVWIDMDialog dialog = VWIDMBaseFactory.instance().getBrowseDialog(idmDoc, 2, resources[0], null);
                    dialog.setTitle(VWResource.s_browseForItem);
                    dialog.setButtonMnemonic(resources[1]);
                    dialog.setButtonTooltip(VWResource.s_select);
                    int returnVal = dialog.showDialog(this.m_authPropertyData.getMainContainer());
                    if (0 == returnVal) {
                        VWAttachment newAttachment = null;
                        idmItem = dialog.getSelectedItem();
                        if (idmItem != null) {
                            newAttachment = idmItem.getVWAttachment();
                            this.m_incomingWSAttachmentFolder.setText(newAttachment.getAttachmentName());
                            this.m_incomingWSAttachmentFolderBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_incomingWSAttachmentFolderBorder.getClientPanel(), 1, Integer.MAX_VALUE));
                            wfDefinition.setIncomingWSAttachmentFolder(newAttachment.toString());
                            this.m_authPropertyData.setDirty();
                        }
                    }
                } else if (src.equals(this.m_validateUsingSchemaCheckBox)) {
                    wfDefinition.setValidateUsingSchema(this.m_validateUsingSchemaCheckBox.isSelected());
                    this.m_authPropertyData.setDirty();
                } else if (src.equals(this.m_versionAgnosticCheckBox)) {
                    if (this.m_versionAgnosticCheckBox.isSelected()) {
                        VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), VWResource.s_versionAgnosticEnableMessage, 2);
                    }
                    wfDefinition.setVersionAgnostic(this.m_versionAgnosticCheckBox.isSelected());
                    this.m_authPropertyData.setDirty();
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void toolbarBorderActionPerformed(VWToolbarBorderActionEvent event) {
        try {
            switch (event.getID()) {
                case 0x10000000: {
                    if (!event.getSource().equals(this.m_incomingWSAttachmentFolderBorder)) break;
                    this.m_incomingWSAttachmentFolder.setText(null);
                    VWWorkflowDefinition wfDefinition = this.m_authPropertyData.getWorkflowDefinition();
                    if (wfDefinition != null) {
                        wfDefinition.setIncomingWSAttachmentFolder(null);
                        this.m_authPropertyData.setDirty();
                    }
                    this.m_incomingWSAttachmentFolderBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_incomingWSAttachmentFolderBorder.getClientPanel(), 2, Integer.MAX_VALUE));
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void handleCoordinationEvent(VWCoordinationEvent event) {
        switch (event.getID()) {
            case 708: {
                this.updateVersionAgnosticControls();
            }
        }
    }

    protected void init(VWAuthPropertyData authPropertyData) {
        try {
            this.m_authPropertyData = authPropertyData;
            this.setLayout(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            gbCons.weighty = 0.0;
            gbCons.anchor = 23;
            gbCons.gridheight = 0;
            gbCons.gridwidth = 1;
            gbCons.insets = new Insets(5, 5, 0, 20);
            this.add((Component)this.getIncomingWSAttachmentFolderPanel(), gbCons);
            ++gbCons.gridx;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            gbCons.gridheight = 1;
            this.m_validateUsingSchemaCheckBox = new JCheckBox(VWResource.s_validateUsingSchema);
            this.m_validateUsingSchemaCheckBox.addActionListener(this);
            this.add((Component)this.m_validateUsingSchemaCheckBox, gbCons);
            ++gbCons.gridy;
            this.m_versionAgnosticCheckBox = new JCheckBox(VWResource.s_showLatestRevision);
            this.m_versionAgnosticCheckBox.addActionListener(this);
            this.add((Component)this.m_versionAgnosticCheckBox, gbCons);
            ++gbCons.gridy;
            gbCons.fill = 1;
            gbCons.weighty = 1.0;
            gbCons.insets = new Insets(5, 20, 0, 20);
            this.m_versionAgnosticTextArea = new JTextArea(VWResource.s_versionAgnosticDisabledMessage);
            this.m_versionAgnosticTextArea.setLineWrap(true);
            this.m_versionAgnosticTextArea.setWrapStyleWord(true);
            this.m_versionAgnosticTextArea.setEditable(false);
            this.m_versionAgnosticTextArea.setOpaque(false);
            this.m_versionAgnosticTextArea.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.m_versionAgnosticTextArea.setVisible(false);
            JScrollPane scrollPane = new JScrollPane(this.m_versionAgnosticTextArea);
            scrollPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.add((Component)scrollPane, gbCons);
            this.reinitialize();
            this.m_authPropertyData.getMapChangeEventNotifier().addMapChangedListener(this);
            this.m_authPropertyData.getDesignerCoreData().getCoordinationEventNotifier().addCoordinationEventListener(this);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected void reinitialize() {
        block6: {
            try {
                VWWorkflowDefinition workflowDefinition;
                this.m_incomingWSAttachmentFolderBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_incomingWSAttachmentFolderBorder.getClientPanel(), 2, Integer.MAX_VALUE));
                this.m_incomingWSAttachmentFolder.setText("");
                this.m_validateUsingSchemaCheckBox.setSelected(false);
                this.m_versionAgnosticCheckBox.setSelected(false);
                if (this.m_authPropertyData == null || (workflowDefinition = this.m_authPropertyData.getWorkflowDefinition()) == null) break block6;
                String incomingAttFolder = workflowDefinition.getIncomingWSAttachmentFolder();
                if (incomingAttFolder != null && incomingAttFolder.length() > 0) {
                    try {
                        VWAttachment vwAtt = new VWAttachment(incomingAttFolder);
                        if (vwAtt != null) {
                            incomingAttFolder = vwAtt.getAttachmentName();
                        }
                        this.m_incomingWSAttachmentFolderBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_incomingWSAttachmentFolderBorder.getClientPanel(), 1, Integer.MAX_VALUE));
                    }
                    catch (Exception ex) {
                        VWDebug.logException(ex);
                    }
                }
                this.m_incomingWSAttachmentFolder.setText(incomingAttFolder);
                this.m_validateUsingSchemaCheckBox.setSelected(workflowDefinition.getValidateUsingSchema());
                this.updateVersionAgnosticControls();
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
            }
        }
    }

    protected void releaseReferences() {
        this.m_authPropertyData.getMapChangeEventNotifier().removeMapChangedListener(this);
        this.m_authPropertyData.getDesignerCoreData().getCoordinationEventNotifier().removeCoordinationEventListener(this);
        if (this.m_incomingWSAttachmentFolderBorder != null) {
            this.m_incomingWSAttachmentFolderBorder.removeToolbarBorderActionNotifier(this);
            this.m_incomingWSAttachmentFolderBorder = null;
        }
        if (this.m_incomingWSAttachmentFolder != null) {
            this.m_incomingWSAttachmentFolder.removeAll();
            this.m_incomingWSAttachmentFolder = null;
        }
        if (this.m_browseButton != null) {
            this.m_browseButton.removeActionListener(this);
            this.m_browseButton = null;
        }
        if (this.m_validateUsingSchemaCheckBox != null) {
            this.m_validateUsingSchemaCheckBox.removeActionListener(this);
            this.m_validateUsingSchemaCheckBox = null;
        }
        if (this.m_versionAgnosticCheckBox != null) {
            this.m_versionAgnosticCheckBox.removeActionListener(this);
            this.m_versionAgnosticCheckBox = null;
        }
        if (this.m_versionAgnosticTextArea != null) {
            this.m_versionAgnosticTextArea.removeAll();
            this.m_versionAgnosticTextArea = null;
        }
        this.m_authPropertyData = null;
    }

    private JPanel getIncomingWSAttachmentFolderPanel() {
        try {
            this.m_incomingWSAttachmentFolderBorder = new VWToolbarBorder(VWResource.s_incomingWSAttachmentFolder, 0x10000000);
            this.m_incomingWSAttachmentFolderBorder.addToolbarBorderActionNotifier(this);
            JPanel panel = this.m_incomingWSAttachmentFolderBorder.getClientPanel();
            panel.setLayout(new BorderLayout(6, 6));
            this.m_incomingWSAttachmentFolder = new JTextField();
            this.m_incomingWSAttachmentFolder.setEditable(false);
            panel.add((Component)this.m_incomingWSAttachmentFolder, "Center");
            this.m_browseButton = new JButton(VWResource.s_ellipse.toString(VWResource.s_browse));
            this.m_browseButton.addActionListener(this);
            panel.add((Component)this.m_browseButton, "After");
            return this.m_incomingWSAttachmentFolderBorder;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private void updateVersionAgnosticControls() {
        boolean bTransferredVersionAgnostic = false;
        String wflName = this.m_authPropertyData.getWorkflowDefinition().getName();
        if (wflName != null && wflName.length() > 0 && this.m_authPropertyData.getVWSession() != null) {
            try {
                VWWorkflowSignature wfSignature = this.m_authPropertyData.getVWSession().fetchWorkflowSignature(wflName);
                if (wfSignature != null && (bTransferredVersionAgnostic = wfSignature.getVersionAgnostic()) && !this.m_authPropertyData.getWorkflowDefinition().getVersionAgnostic()) {
                    this.m_authPropertyData.getWorkflowDefinition().setVersionAgnostic(true);
                    this.m_authPropertyData.setDirty();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.m_authPropertyData.getWorkflowDefinition().getVersionAgnostic()) {
            this.m_versionAgnosticCheckBox.setEnabled(!bTransferredVersionAgnostic);
            this.m_versionAgnosticCheckBox.setSelected(true);
            this.m_versionAgnosticTextArea.setVisible(bTransferredVersionAgnostic);
        } else {
            this.m_versionAgnosticCheckBox.setEnabled(true);
            this.m_versionAgnosticCheckBox.setSelected(false);
            this.m_versionAgnosticTextArea.setVisible(false);
        }
    }
}

